IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_NF_ENT_NFE_PEND]'))
DROP TRIGGER [dbo].[TRG_EST_NF_ENT_NFE_PEND]
GO
GO
GO
GO
CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_NFE_PEND] ON [dbo].[EST_NF_ENT_EF_NF_CTR_NF] FOR INSERT AS

--Pendncia de entrada de nota fiscal eletronica
INSERT INTO EST_NF_ENT_NFE_PEND (CD_EMP, CD_FILIAL, CD_NF)
 SELECT 
  t.CD_EMP, 
  t.CD_FILIAL, 
  t.CD_NF_ENT
    FROM 
     INSERTED t INNER JOIN EST_NF_SERIE sr_nf ON
   t.CD_EMP = sr_nf.CD_EMP  
   AND t.CD_NF_SERIE = sr_nf.CD_NF_SERIE 
   AND sr_nf.TP_SR_NFE = 1
   AND isnull(t.FLAG_NOTA_INTEGRACAO,0) <> 1
 WHERE     
  NOT EXISTS (SELECT 
      CD_EMP 
     FROM 
      EST_NF_ENT_NFE_PEND pend
     WHERE 
      t.CD_EMP      = pend.CD_EMP AND 
      t.CD_FILIAL   = pend.CD_FILIAL AND 
      t.CD_NF_ENT   = pend.CD_NF);